/**

This entire file was created by Angelo

**/

package edu.unl.consystlab.sudokuSolver;
//References:
//http://www.idevelopment.info/data/Programming/java/xml/SAXExample.java
//http://en.wikipedia.org/wiki/Document_Type_Definition

import java.io.*;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.List;
import java.util.LinkedList;
import java.util.TimeZone;

import javax.swing.JTextField;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.SAXException;


public class parserArray {

	private constraintProblem describedProblem;
	private String [] numbers;

	//default constructor
	public parserArray()
	{
	}

	public void parseArray(String [] tmpNumbers)
	{
		describedProblem = new constraintProblem();
		this.numbers = tmpNumbers;
		//System.out.println("numbers.length");
		//System.out.println(numbers.length);
		
		//System.out.println("numbers[0]");
		//System.out.println(numbers[0]);
		
		interpretPresentation();
			
		interpretDimensions();
		
		//Generate the domain
		// it will be a list equaling 1..(unitLines*unitColumns)
		generateDomain(describedProblem);
			
		//Generate the variables
		// there will be 1..(unitLines*unitColumns)^2
		generateVariables(describedProblem);
			
		//Generate all the relations?
		//not for now
			
		//Generate all the constraints?
		generateConstraints();
			
			
		interpretPreassign();
		//in here change values and initial domains
	}
	
	public void parseArray(String [] tmpNumbers, int diffLevel)
	{
		describedProblem = new constraintProblem();
		this.numbers = tmpNumbers;
		//System.out.println("numbers.length");
		//System.out.println(numbers.length);
		
		//System.out.println("numbers[0]");
		//System.out.println(numbers[0]);
		
		interpretPresentation(diffLevel);
			
		interpretDimensions();
		
		//Generate the domain
		// it will be a list equaling 1..(unitLines*unitColumns)
		generateDomain(describedProblem);
			
		//Generate the variables
		// there will be 1..(unitLines*unitColumns)^2
		generateVariables(describedProblem);
			
		//Generate all the relations?
		//not for now
			
		//Generate all the constraints?
		generateConstraints();
			
			
		interpretPreassign();
		//in here change values and initial domains
	}


	public constraintProblem getProblem()
	{
		return describedProblem;
	}
	
	private void interpretPresentation()
	{
		Calendar cal = Calendar.getInstance(TimeZone.getDefault());
	    
	    String DATE_FORMAT = "MM-dd-yyyy-hhmmss";
	    java.text.SimpleDateFormat sdf = 
	          new java.text.SimpleDateFormat(DATE_FORMAT);
	    	
		//set the name of our problem instance
		describedProblem.setName(sdf.format(cal.getTime()));		
		
	}
	
	private void interpretPresentation(int diffLevel)
	{
		Calendar cal = Calendar.getInstance(TimeZone.getDefault());
	    
	    String DATE_FORMAT = "MM-dd-yyyy-hhmmss";
	    java.text.SimpleDateFormat sdf = 
	          new java.text.SimpleDateFormat(DATE_FORMAT);
	    	
		//set the name of our problem instance
		describedProblem.setName(sdf.format(cal.getTime()));		
		
	}
	
	private String getCharacterDataFromElement(Element e) {
		   Node child = e.getFirstChild();
		   if (child instanceof CharacterData) {
		     CharacterData cd = (CharacterData) child;
		       return cd.getData();
		     }
		   return "?";
	}

	private void interpretDimensions()
	{
		describedProblem.setDimensionsForXML3("9", "9");
	}

	private void interpretPreassign()
	{
		int arrayIndex = 1;	
		
		for(int i = 1;i <= 9; i++)
 		{
			for (int j = 1; j <= 9; j++) {
 											
 				//assign the value to the variable
 				problemVariable meh = (describedProblem.getVariable( i + "," + j));
 				String tmpAsigned = numbers[arrayIndex++];
 				if ((!tmpAsigned.equals("0")) && (!tmpAsigned.equals(".")) ) {
 				   meh.setAssigned (tmpAsigned);
 				} 
 			} 			
 		} 		
	}
	
	private void generateDomain(constraintProblem describedProblem)
	{
		problemDomain newDomain = new problemDomain("standardDomain", describedProblem );
		String range;
		int max = describedProblem.linesPerUnit * describedProblem.columnsPerUnit;
		range = "1.." + max;
		newDomain.addRangeToDomain( range );
	}

	private void generateVariables(constraintProblem parentProblem)
	{
 		for(int lineIndex = 1; lineIndex <= (parentProblem.totalLines); lineIndex++)
 		{
 	 		for(int columnIndex = 1; columnIndex <= (parentProblem.totalColumns); columnIndex++)
 	 		{ 	
 	 			problemVariable newVariable = new problemVariable(
				( lineIndex + "," + columnIndex ), describedProblem);
 	 			newVariable.setDomain( "standardDomain" );
 	 		}
 		}
	}

//	private void interpretRelations(NodeList relationNodeList)
//	{
// 		for(int i = 0;i < relationNodeList.getLength(); i++)
// 		{
// 			constraintRelation newRelation = new constraintRelation(
//				relationNodeList.item(i).getAttributes().getNamedItem("name").getNodeValue(), describedProblem);
//			newRelation.setDomains ( relationNodeList.item(i).getAttributes().getNamedItem("domain").getNodeValue() );
//			newRelation.setConflicts ( relationNodeList.item(i).getAttributes().getNamedItem("conflicts").getNodeValue() );
//
//		}
//
//	}

//	need to do
	private void generateConstraints()
	{
 		for(int cellLineIndex = 1; cellLineIndex <= describedProblem.totalLines; cellLineIndex++)
 		{
 	 		for(int cellColumnIndex = 1; cellColumnIndex <= describedProblem.totalColumns; cellColumnIndex++)
 	 		{
 	 			//add the line constraints
 	 			for(int colpointer = cellColumnIndex + 1; colpointer <= describedProblem.totalColumns; colpointer++ )
 	 			{
 	 				problemConstraint newConstraint = new binaryIntensiveConstraint(
 	 						cellLineIndex + "," + cellColumnIndex + " " + cellLineIndex + "," + colpointer,
 	 						describedProblem);
 	 			}
 	 			
 	 			//add the column constraints
 	 			for(int rowPointer = cellLineIndex + 1; rowPointer <= describedProblem.totalLines; rowPointer++ )
 	 			{
 	 				problemConstraint newConstraint = new binaryIntensiveConstraint(
 	 						cellLineIndex + "," + cellColumnIndex + " " + rowPointer + "," + cellColumnIndex, 
 	 						describedProblem);
 	 			} 			
 	 		}
 		}

 		//add the remaining unit constraints
 		//number of units accross is = to describedProblem.linesPerUnit
 		for(int unitLine = 0; unitLine < describedProblem.columnsPerUnit; unitLine++)
 		{
 			for(int unitColumn = 0; unitColumn < describedProblem.linesPerUnit; unitColumn++)
 			{
 				//inside of every unit add constraints at every row and every column but the last one
 				// to avoid repeating constraints the rule is you can look up but not back.
 				for(int unitLineIndex = 1; unitLineIndex <= describedProblem.linesPerUnit; unitLineIndex++)
 				{
 					//this only goes to less than becase of the rule where you don't look back the last row
 					//will add no constraints
 					for(int unitColumnIndex = 1; unitColumnIndex < describedProblem.columnsPerUnit; unitColumnIndex++)
 					{
						//since we don't mind looking up we set the line pointer @ 0
 						for(int linePointerIndex = 1; linePointerIndex <= describedProblem.linesPerUnit; linePointerIndex++)
 						{
 							//since we don't look back we set the column pointer @ +1
 							for(int columnPointerIndex = unitColumnIndex + 1; columnPointerIndex <= describedProblem.columnsPerUnit; columnPointerIndex++)
 							{
 								//make sure we are not repeating the same line
 								if(linePointerIndex != unitLineIndex)
 								{
	 								//now we add the constraints
	 			 	 				problemConstraint newConstraint = new binaryIntensiveConstraint(
	 			 	 						((unitLine * describedProblem.linesPerUnit) + unitLineIndex) + "," + 
	 			 	 						((unitColumn * describedProblem.columnsPerUnit) + unitColumnIndex) + " " + 
	 			 	 						((unitLine * describedProblem.linesPerUnit) + linePointerIndex) + "," + 
	 			 	 						((unitColumn * describedProblem.columnsPerUnit) + columnPointerIndex),
	 			 	 						describedProblem);
 								}
 							}
 						}
 					}
 				}
 			}
 		}
 			
		//add the All diff constraints.
		//start with the lines
 		for(int cellLineIndex = 1; cellLineIndex <= describedProblem.totalLines; cellLineIndex++)
 		{
 			String variablesAffected = "";
 			
 	 		for(int cellColumnIndex = 1; cellColumnIndex <= describedProblem.totalColumns; cellColumnIndex++)
 	 		{

 	 				variablesAffected = variablesAffected + cellLineIndex + "," + cellColumnIndex + " ";
 	 		}	 	 			
 	 			variablesAffected.trim();
 	 			problemConstraint newConstraint = new nonBinaryIntensiveConstraint( variablesAffected,
 	 					describedProblem, "L" + cellLineIndex); 	 	 			
 		}
 		
		//do the columns
 		for(int cellColIndex = 1; cellColIndex <= describedProblem.totalLines; cellColIndex++)
 		{
 			String variablesAffected = "";
 			
 	 		for(int cellLineIndex = 1; cellLineIndex <= describedProblem.totalColumns; cellLineIndex++)
 	 		{

 	 				variablesAffected = variablesAffected + cellLineIndex + "," + cellColIndex + " ";
 	 		}	 	 			
 	 			variablesAffected.trim();
 	 			problemConstraint newConstraint = new nonBinaryIntensiveConstraint( variablesAffected,
 	 					describedProblem, "C" + cellColIndex); 	 	 			
 		}
 		
 		//add the unit constraints
 		//number of units accross is = to describedProblem.linesPerUnit
 		for(int unitLine = 0; unitLine < describedProblem.columnsPerUnit; unitLine++)
 		{
 			for(int unitColumn = 0; unitColumn < describedProblem.linesPerUnit; unitColumn++)
 			{
	 			String variablesAffected = "";

 				for(int unitLineIndex = 1; unitLineIndex <= describedProblem.linesPerUnit; unitLineIndex++)
 				{
 					for(int unitColumnIndex = 1; unitColumnIndex <= describedProblem.columnsPerUnit; unitColumnIndex++)
 					{
	 	 				variablesAffected = variablesAffected + (unitLine*describedProblem.linesPerUnit + unitLineIndex)
	 	 					+ "," + (unitColumn*describedProblem.columnsPerUnit + unitColumnIndex) + " ";	
 					}
 				}
	 	 		variablesAffected.trim();
		 	 	problemConstraint newConstraint = new nonBinaryIntensiveConstraint( variablesAffected,
		 	 			describedProblem, "U" + (unitLine+1) + "," + (unitColumn+1));
 			}
 		}
		
// 			problemConstraint newConstraint = new problemConstraint(
//				constraintNodeList.item(i).getAttributes().getNamedItem("scope").getNodeValue(), describedProblem);
//			newConstraint.setRelation ( constraintNodeList.item(i).getAttributes().getNamedItem("relation").getNodeValue() );
	}

}
